/*
 * This File is one of the examples from Java Application Development
 * Do not reproduce this code for others or use it in a commercial setting without prior permission from the author.
 */

package salesApplication;

import java.util.function.Predicate;
import products.Item;

/**
 *
 * @author Matthew Gregory
 * @website www.matthewgregory-author.com.au
 *
 */
public class Search {
    //This class allows us to search our price lists for items where fields such as name
    //and description match a specified search criteria.

    //Given a price list, search for all items where something in the description or name matches 
    //the search string
    public static PriceList searchList(PriceList priceList,String pattern){
        //Simple search for string in name or description
        
        //Thia method creates a filter we will use to search and saves it in a lambda expression.
        //In our case the logic is that the pattern should exist in either the name or the despcription 
        //of and item in our price list.
        Predicate<Item> searchFunctionality = (item)->{
            //Search logic goes here!
            return item.getName().contains(pattern)||item.getDescription().contains(pattern); 
        };
        
        //Use the lambda expression to filter the list.
        return priceList.filterList(searchFunctionality);
    }
    
}
